<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite solicitudes desde cualquier origen (cuidado con esto en producción)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_Cliente(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@IdCliente)");
$sql->bind_Param("isssssssssssssisssiiiiis", $datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7],
    $datos[8], $datos[9], $datos[10], $datos[11], $datos[12], $datos[13], $datos[14], $datos[15], $datos[16], $datos[17], $datos[18],
    $datos[19], $datos[20], $datos[21], $datos[22], $datos[23]);

$sql->execute();

$respuesta = array();

if ($datos[23] == "NUEVO") {
    $result = mysqli_query($conn, "SELECT @IdCliente as nIdCliente");
    $mensaje = mysqli_fetch_assoc($result);

    if ($mensaje['nIdCliente'] > 0) {
        // Aquí agregamos la lógica para insertar en remitente
        try {
            $sqlInsertRemitente = $conn->prepare("INSERT INTO remitente (nombre, tipo_docidentidad, documento_identidad, direccion, tipo, cliente_id, empresa_id) VALUES (?, ?, ?, ?, 'C', ?, ?)");
            $sqlInsertRemitente->bind_param("ssssii", $datos[2], $datos[0], $datos[1], $datos[3], $mensaje['nIdCliente'], $datos[19]);
            $sqlInsertRemitente->execute();
        } catch (Exception $e) {
            // Manejar cualquier error que pueda ocurrir durante la inserción en remitente
            $resultado['ESTADO'] = "0";
            $resultado['ID'] = "0";
            $resultado['MENSAJE'] = "ERROR AL INSERTAR EN LA TABLA REMITENTE: " . $e->getMessage();
        }
        $resultado = array();
        $resultado['ESTADO'] = "1";
        $resultado['ID'] = $mensaje['nIdCliente'];
        $resultado['MENSAJE'] = "LA INFORMACION GUARDO CORRECTAMENTE";
        
    } else {
        $resultado = array();
        $resultado['ESTADO'] = "0";
        $resultado['ID'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUARDAR LA INFORMACIÓN: " . mysqli_error($conn);
    }
} else {
    $sqlRemitente = $conn->prepare("UPDATE remitente SET nombre = ?, tipo_docidentidad = ?, documento_identidad = ?, direccion = ? WHERE cliente_id = ? AND tipo = 'C'");
    $sqlRemitente->bind_param("ssssi", $datos[2], $datos[0], $datos[1], $datos[3], $datos[22]);
    $sqlRemitente->execute();

    $resultado = array();
    $resultado['ESTADO'] = "1";
    $resultado['ID'] = $datos[22].'';
    $resultado['MENSAJE'] = "LA INFORMACION ACTUALIZO CORRECTAMENTE";
}

mysqli_close($conn);

// Devolver la respuesta como un objeto JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
