<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);

// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
    // Acceder a los valores individuales de los datos combinados
    $cRuc = $data['Ruc'];
    $cCodSunat = $data['CodSunat'];
    $cNombre = $data['Nombre'];
    $cDireccion = $data['Direccion'];
    $cUbigeo = $data['Ubigeo'];
    $cDistrito = $data['Distrito']; 
    $cProvincia = $data['Provincia'];
    $cRegion = $data['Region'];
    $cEmail = $data['Email'];
    $cFono1 = $data['Fono1'];
    $cFono2 = $data['Fono2'];
    $cCuentaBco1 = $data['CtaBancaria1'];
    $cCuentaBco2 = $data['CtaBancaria2'];
    $cAfecta_Cmp = $data['AfectoCmp'];
    $cPIGV_Cmp = $data['PIGV_Cmp'];
    $cAfecta_Vta = $data['AfectoVta'];
    $cPIGV_Vta = $data['PIGV_Vta'];
    $cEtiquetera = $data['Etiquetera'];
    $cAlmacen_Id = $data['IdAlmacen'];
    $cEmpresa_Id = $data['IdEmpresa'];
    $cnIdSucursal = $data['nIdSucursal'];
    $cEstado = $data['Estado'];

    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla sucursales
        $querySede = "INSERT INTO sucursales(ruc, codigo_sunat, nombre, direccion, ubigeo, distrito, provincia, region, email, telefono1, telefono2,
        cuenta_bancaria1, cuenta_bancaria2, afecto_igvCmp, porcentaje_igvCmp, afecto_igvVta, porcentaje_igvVta, imprime_ticket, almacen_id, empresa_id)
           VALUES('$cRuc', '$cCodSunat', '$cNombre', '$cDireccion', '$cUbigeo', '$cDistrito', '$cProvincia', '$cRegion', '$cEmail', '$cFono1', '$cFono2', 
            '$cCuentaBco1', '$cCuentaBco2', '$cAfecta_Cmp', '$cPIGV_Cmp', '$cAfecta_Vta', '$cPIGV_Vta', '$cEtiquetera', '$cAlmacen_Id', '$cEmpresa_Id')";

        $resultadoSede = mysqli_query($conn, $querySede);
        if (!$resultadoSede) {
            throw new Exception(mysqli_error($conn));
        }

        // Obtener el ID del último registro insertado
        $IdSede = mysqli_insert_id($conn);
        
        // Ejemplo de inserción en la tabla almacenes_sede
        foreach ($data['almacenes'] as $almacenes_) {
            $cSede_Id = $almacenes_['sucursal_id'];
            $cAlm_Id = $almacenes_['almacen_id'];

            $queryAlmacenes = "INSERT INTO almacen_sede(sucursal_id, almacen_id, empresa_id) 
                VALUES('$cSede_Id', '$cAlm_Id', '$cEmpresa_Id')";
            
            $resultadoAlmacenes = mysqli_query($conn, $queryAlmacenes);
            if (!$resultadoAlmacenes) {
                throw new Exception(mysqli_error($conn));
            }
        }

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_Almacenes = "UPDATE almacen_sede SET IUD = 'D' WHERE sucursal_id  = $cnIdSucursal";
        $resultadoUpd_Almacenes = mysqli_query($conn, $queryUpd_Almacenes);        
        if (!$resultadoUpd_Almacenes) {
            throw new Exception(mysqli_error($conn));
        }
        
        $queryUpd_Sede = "UPDATE sucursales SET ruc = '$cRuc', codigo_sunat = '$cCodSunat', nombre = '$cNombre', direccion = '$cDireccion',
            ubigeo = '$cUbigeo', distrito = '$cDistrito', provincia = '$cProvincia', region = '$cRegion', email = '$cEmail', 
            telefono1 = '$cFono1', telefono2 = '$cFono2', cuenta_bancaria1 = '$cCuentaBco1', cuenta_bancaria2 = '$cCuentaBco2', 
            afecto_igvCmp = '$cAfecta_Cmp', porcentaje_igvCmp = '$cPIGV_Cmp', afecto_igvVta = '$cAfecta_Vta', porcentaje_igvVta = '$cPIGV_Vta',
            imprime_ticket = '$cEtiquetera', almacen_id = '$cAlmacen_Id'
        WHERE id = $cnIdSucursal";
        
        $resultadoUpd_Sede = mysqli_query($conn, $queryUpd_Sede);        
        if (!$resultadoUpd_Sede) {
            throw new Exception(mysqli_error($conn));
        }

        // Ejemplo de inserción en la tabla sucursales_usuarios
        foreach ($data['almacenes'] as $almacenes_) {
            $cSede_Id = $almacenes_['sucursal_id'];
            $cAlm_Id = $almacenes_['almacen_id'];

            $queryAlmacenes = "INSERT INTO almacen_sede(sucursal_id, almacen_id, empresa_id) 
                VALUES('$cSede_Id', '$cAlm_Id', '$cEmpresa_Id')";
            
            $resultadoAlmacenes = mysqli_query($conn, $queryAlmacenes);
            if (!$resultadoAlmacenes) {
                throw new Exception(mysqli_error($conn));
            }
        }

        //Elimina sucursales_usuario para Evitar la Duplicidad
        $queryDel_Almacenes = "DELETE FROM almacen_sede WHERE sucursal_id  = $cnIdSucursal AND IUD = 'D'";
        $resultadoDel_Almacenes = mysqli_query($conn, $queryDel_Almacenes);        
        if (!$resultadoDel_Almacenes) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>